<?php
class vb_optimise_apc extends vb_optimise_operator
{
	public function connect()
	{
		if (!function_exists('apc_fetch'))
		{
			return false;
		}

		return true;
	}

	public function get($id = '')
	{
		if (!$this->connect())
		{
			return false;
		}

		return $this->handle_blank(apc_fetch($this->id($id)));
	}

	public function set($id = '', $value = '')
	{
		if (!$this->connect())
		{
			return false;
		}

		if (!is_array($value) && trim($value) == '')
		{
			$value = '{VBO_BLANK}';
		}

		apc_store($this->id($id), $value);
	}

	public function flush($silent = false)
	{
		apc_clear_cache('user');
	}
}
?>